/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers.data;

import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.api.IContainer;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.entity.data.IPlayerMail;
import noppes.npcs.controllers.QuestController;
import noppes.npcs.controllers.data.Quest;

public class PlayerMail
implements IInventory,
IPlayerMail {
    public boolean beenRead;
    public boolean returned;
    public NonNullList<ItemStack> items;
    public NBTTagCompound message;
    public int money;
    public int ransom;
    public int questId;
    public String sender;
    public String title;
    public long timeWillCome;
    public long timeWhenReceived;

    public PlayerMail() {
        this.func_174888_l();
        this.timeWillCome = 0L;
        this.timeWhenReceived = System.currentTimeMillis();
    }

    public void func_174888_l() {
        this.title = "";
        this.sender = "";
        this.message = new NBTTagCompound();
        this.beenRead = false;
        this.returned = false;
        this.questId = -1;
        if (this.items == null) {
            this.items = NonNullList.func_191197_a((int)4, (Object)ItemStack.field_190927_a);
        } else {
            this.items.clear();
        }
        this.money = 0;
        this.ransom = 0;
        this.timeWhenReceived = System.currentTimeMillis();
    }

    public void func_174886_c(@Nonnull EntityPlayer player) {
    }

    public PlayerMail copy() {
        PlayerMail mail = new PlayerMail();
        mail.readNBT(this.writeNBT());
        return mail;
    }

    @Nonnull
    public ItemStack func_70298_a(int slot, int count) {
        ItemStack itemstack = ItemStackHelper.func_188382_a(this.items, (int)slot, (int)count);
        if (!itemstack.func_190926_b()) {
            this.func_70296_d();
        }
        return itemstack;
    }

    @Override
    public IContainer getContainer() {
        return Objects.requireNonNull(NpcAPI.Instance()).getIContainer(this);
    }

    @Nonnull
    public ITextComponent func_145748_c_() {
        return new TextComponentString(this.func_70005_c_());
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public int func_174890_g() {
        return 0;
    }

    public int func_70297_j_() {
        return 64;
    }

    @Override
    public int getMoney() {
        return this.money;
    }

    @Nonnull
    public String func_70005_c_() {
        return "Mail Inventory";
    }

    @Override
    public Quest getQuest() {
        return QuestController.instance != null ? QuestController.instance.quests.get(this.questId) : null;
    }

    @Override
    public int getRansom() {
        return this.ransom;
    }

    @Override
    public String getSender() {
        return this.sender;
    }

    public int func_70302_i_() {
        return this.items.size();
    }

    @Nonnull
    public ItemStack func_70301_a(int slot) {
        return (ItemStack)this.items.get(slot);
    }

    @Override
    public String getSubject() {
        return this.title;
    }

    @Override
    public String[] getText() {
        ArrayList<String> list = new ArrayList<String>();
        NBTTagList pages = this.message.func_150295_c("pages", 8);
        for (int i = 0; i < pages.func_74745_c(); ++i) {
            list.add(pages.func_150307_f(i));
        }
        return list.toArray(new String[0]);
    }

    public boolean func_145818_k_() {
        return false;
    }

    public boolean hasQuest() {
        return this.getQuest() != null;
    }

    public boolean func_191420_l() {
        for (int slot = 0; slot < this.func_70302_i_(); ++slot) {
            ItemStack item = this.func_70301_a(slot);
            if (NoppesUtilServer.IsItemStackNull(item) || item.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public boolean func_94041_b(int slot, @Nonnull ItemStack item) {
        return true;
    }

    public boolean isReturned() {
        return this.returned;
    }

    public boolean func_70300_a(@Nonnull EntityPlayer player) {
        return true;
    }

    public boolean isValid() {
        return !this.title.isEmpty() && !this.message.func_150296_c().isEmpty() && !this.sender.isEmpty();
    }

    public void func_70296_d() {
    }

    public void func_174889_b(@Nonnull EntityPlayer player) {
    }

    public void readNBT(NBTTagCompound compound) {
        this.title = compound.func_74779_i("Subject");
        this.sender = compound.func_74779_i("Sender");
        this.message = compound.func_74775_l("Message");
        this.beenRead = compound.func_74767_n("BeenRead");
        this.returned = compound.func_74767_n("Returned");
        this.timeWillCome = compound.func_74763_f("TimeWillCome");
        this.timeWhenReceived = compound.func_74763_f("TimeWhenReceived");
        if (compound.func_74764_b("MailQuest")) {
            this.questId = compound.func_74762_e("MailQuest");
        }
        this.items.clear();
        NBTTagList nbttaglist = compound.func_150295_c("MailItems", 10);
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbt = nbttaglist.func_150305_b(i);
            int j = nbt.func_74771_c("Slot") & 0xFF;
            if (j >= this.items.size()) continue;
            this.items.set(j, (Object)new ItemStack(nbt));
        }
        this.money = compound.func_74762_e("Money");
        this.ransom = compound.func_74762_e("Ransom");
    }

    @Nonnull
    public ItemStack func_70304_b(int slot) {
        return (ItemStack)this.items.set(slot, (Object)ItemStack.field_190927_a);
    }

    public void func_174885_b(int id, int value) {
    }

    public void func_70299_a(int index, @Nonnull ItemStack stack) {
        this.items.set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        this.func_70296_d();
    }

    @Override
    public void setMoney(int money) {
        if (money < 0) {
            money = 0;
        }
        this.money = money;
    }

    @Override
    public void setQuest(int id) {
        this.questId = id;
    }

    @Override
    public void setRansom(int money) {
        if (money < 0) {
            money = 0;
        }
        this.ransom = money;
    }

    @Override
    public void setSender(String sender) {
        this.sender = sender;
    }

    @Override
    public void setSubject(String subject) {
        this.title = subject;
    }

    @Override
    public void setText(String[] pages) {
        NBTTagList list = new NBTTagList();
        if (pages != null) {
            for (String page : pages) {
                list.func_74742_a((NBTBase)new NBTTagString(page));
            }
        }
        this.message.func_74782_a("pages", (NBTBase)list);
    }

    public NBTTagCompound writeNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74778_a("Subject", this.title);
        compound.func_74778_a("Sender", this.sender);
        compound.func_74782_a("Message", (NBTBase)this.message);
        compound.func_74757_a("BeenRead", this.beenRead);
        compound.func_74757_a("Returned", this.returned);
        compound.func_74772_a("TimeWillCome", this.timeWillCome);
        compound.func_74772_a("TimeWhenReceived", this.timeWhenReceived);
        compound.func_74768_a("MailQuest", this.questId);
        if (this.hasQuest()) {
            compound.func_74778_a("MailQuestTitle", this.getQuest().getTitle());
        }
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.items.size(); ++i) {
            if (((ItemStack)this.items.get(i)).func_190926_b()) continue;
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74774_a("Slot", (byte)i);
            ((ItemStack)this.items.get(i)).func_77955_b(nbt);
            nbttaglist.func_74742_a((NBTBase)nbt);
        }
        compound.func_74782_a("MailItems", (NBTBase)nbttaglist);
        compound.func_74768_a("Money", this.money);
        compound.func_74768_a("Ransom", this.ransom);
        return compound;
    }
}

